/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.http.Authorization;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public abstract class ImageUpload {
    public static String DEFAULT_TWITPIC_API_KEY = null;

    public abstract String upload(File var1) throws TwitterException;

    public abstract String upload(File var1, String var2) throws TwitterException;

    public abstract String upload(String var1, InputStream var2) throws TwitterException;

    public abstract String upload(String var1, InputStream var2, String var3) throws TwitterException;

    public static ImageUpload getTwitpicUploader(Twitter twitter) throws TwitterException {
        Authorization auth = twitter.getAuthorization();
        if (auth instanceof OAuthAuthorization) {
            return ImageUpload.getTwitpicUploader(DEFAULT_TWITPIC_API_KEY, (OAuthAuthorization)auth);
        }
        ImageUpload.ensureBasicEnabled(auth);
        return ImageUpload.getTwitpicUploader((BasicAuthorization)auth);
    }

    public static ImageUpload getTwitpicUploader(BasicAuthorization auth) {
        return new TwitpicBasicAuthUploader(auth);
    }

    public static ImageUpload getTwitpicUploader(String twitpicAPIKey, OAuthAuthorization auth) {
        return new TwitpicOAuthUploader(twitpicAPIKey, auth);
    }

    public static ImageUpload getTweetPhotoUploader(String tweetPhotoAPIKey, OAuthAuthorization auth) {
        return new TweetPhotoOAuthUploader(tweetPhotoAPIKey, auth);
    }

    public static ImageUpload getYFrogUploader(Twitter twitter) throws TwitterException {
        Authorization auth = twitter.getAuthorization();
        if (auth instanceof OAuthAuthorization) {
            return ImageUpload.getYFrogUploader(twitter.getScreenName(), (OAuthAuthorization)auth);
        }
        ImageUpload.ensureBasicEnabled(auth);
        return ImageUpload.getYFrogUploader((BasicAuthorization)auth);
    }

    public static ImageUpload getYFrogUploader(BasicAuthorization auth) {
        return new YFrogBasicAuthUploader(auth);
    }

    public static ImageUpload getYFrogUploader(String userId, OAuthAuthorization auth) {
        return new YFrogOAuthUploader(userId, auth);
    }

    public static ImageUpload getImgLyUploader(OAuthAuthorization auth) {
        return new ImgLyOAuthUploader(auth);
    }

    public static ImageUpload getTwitgooUploader(OAuthAuthorization auth) {
        return new TwitgooOAuthUploader(auth);
    }

    private static void ensureBasicEnabled(Authorization auth) {
        if (!(auth instanceof BasicAuthorization)) {
            throw new IllegalStateException("user ID/password combination not supplied");
        }
    }

    private static HttpParameter[] appendHttpParameters(HttpParameter[] src, HttpParameter[] dst) {
        int i;
        int srcLen = src.length;
        int dstLen = dst.length;
        HttpParameter[] ret = new HttpParameter[srcLen + dstLen];
        for (i = 0; i < srcLen; ++i) {
            ret[i] = src[i];
        }
        for (i = 0; i < dstLen; ++i) {
            ret[srcLen + i] = dst[i];
        }
        return ret;
    }

    public static class TwitgooOAuthUploader
    extends ImageUpload {
        private OAuthAuthorization auth;
        private static final String TWITGOO_UPLOAD_URL = "http://twitgoo.com/api/uploadAndPost";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.json";

        public TwitgooOAuthUploader(OAuthAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            int j;
            String h;
            int i;
            String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Auth-Service-Provider", TWITTER_VERIFY_CREDENTIALS);
            headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("no_twitter_post", "1")};
            params = ImageUpload.appendHttpParameters(params, additionalParams);
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWITGOO_UPLOAD_URL, params, headers);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("Twitgoo image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp status=\"ok\">")) {
                int j2;
                String h2 = "<mediaurl>";
                int i2 = response.indexOf(h2);
                if (i2 != -1 && (j2 = response.indexOf("</mediaurl>", i2 + h2.length())) != -1) {
                    return response.substring(i2 + h2.length(), j2);
                }
            } else if (response.contains("<rsp status=\"fail\">") && (i = response.indexOf(h = "msg=\"")) != -1 && (j = response.indexOf("\"", i + h.length())) != -1) {
                String msg = response.substring(i + h.length(), j);
                throw new TwitterException("Invalid Twitgoo response: " + msg);
            }
            throw new TwitterException("Unknown Twitgoo response", httpResponse);
        }

        private String generateVerifyCredentialsAuthorizationHeader() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "OAuth realm=\"http://api.twitter.com/\"," + OAuthAuthorization.encodeParameters(oauthSignatureParams, ",", true);
        }
    }

    public static class ImgLyOAuthUploader
    extends ImageUpload {
        private OAuthAuthorization auth;
        private static final String IMGLY_UPLOAD_URL = "http://img.ly/api/2/upload.json";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.json";

        public ImgLyOAuthUploader(OAuthAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Auth-Service-Provider", TWITTER_VERIFY_CREDENTIALS);
            headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
            HttpParameter[] params = new HttpParameter[]{};
            params = ImageUpload.appendHttpParameters(params, additionalParams);
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(IMGLY_UPLOAD_URL, params, headers);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("ImgLy image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            try {
                JSONObject json = new JSONObject(response);
                if (!json.isNull("url")) {
                    return json.getString("url");
                }
            }
            catch (JSONException e) {
                throw new TwitterException("Invalid ImgLy response: " + response, e);
            }
            throw new TwitterException("Unknown ImgLy response", httpResponse);
        }

        private String generateVerifyCredentialsAuthorizationHeader() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "OAuth realm=\"http://api.twitter.com/\"," + OAuthAuthorization.encodeParameters(oauthSignatureParams, ",", true);
        }
    }

    public static class TweetPhotoOAuthUploader
    extends ImageUpload {
        private String tweetPhotoAPIKey;
        private OAuthAuthorization auth;
        private static final String TWEETPHOTO_UPLOAD_URL = "http://tweetphotoapi.com/api/upload.aspx";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.xml";

        public TweetPhotoOAuthUploader(String tweetPhotoAPIKey, OAuthAuthorization auth) {
            if (tweetPhotoAPIKey == null || "".equals(tweetPhotoAPIKey)) {
                throw new IllegalArgumentException("The TweetPhoto API Key supplied to the OAuth image uploader can't be null or empty");
            }
            this.tweetPhotoAPIKey = tweetPhotoAPIKey;
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Auth-Service-Provider", TWITTER_VERIFY_CREDENTIALS);
            headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("api_key", this.tweetPhotoAPIKey)};
            params = ImageUpload.appendHttpParameters(params, additionalParams);
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWEETPHOTO_UPLOAD_URL, params, headers);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 201) {
                throw new TwitterException("Twitpic image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<Error><ErrorCode>")) {
                String error = response.substring(response.indexOf("<ErrorCode>") + "<ErrorCode>".length(), response.lastIndexOf("</ErrorCode>"));
                throw new TwitterException("TweetPhoto image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<Status>OK</Status>")) {
                String media = response.substring(response.indexOf("<MediaUrl>") + "<MediaUrl>".length(), response.indexOf("</MediaUrl>"));
                return media;
            }
            throw new TwitterException("Unknown TweetPhoto response", httpResponse);
        }

        private String generateVerifyCredentialsAuthorizationHeader() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "OAuth realm=\"http://api.twitter.com/\"," + OAuthAuthorization.encodeParameters(oauthSignatureParams, ",", true);
        }
    }

    private static class TwitpicBasicAuthUploader
    extends ImageUpload {
        private BasicAuthorization auth;
        private static final String TWITPIC_UPLOAD_URL = "https://twitpic.com/api/upload";

        public TwitpicBasicAuthUploader(BasicAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword())};
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWITPIC_UPLOAD_URL, params = ImageUpload.appendHttpParameters(params, additionalParams));
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("Twitpic image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("Twitpic image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown Twitpic response", httpResponse);
        }
    }

    private static class TwitpicOAuthUploader
    extends ImageUpload {
        private String twitpicAPIKey;
        private OAuthAuthorization auth;
        private static final String TWITPIC_UPLOAD_URL = "https://twitpic.com/api/2/upload.json";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.json";

        public TwitpicOAuthUploader(String twitpicAPIKey, OAuthAuthorization auth) {
            if (twitpicAPIKey == null || "".equals(twitpicAPIKey)) {
                throw new IllegalArgumentException("The Twitpic API Key supplied to the OAuth image uploader can't be null or empty");
            }
            this.twitpicAPIKey = twitpicAPIKey;
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Auth-Service-Provider", TWITTER_VERIFY_CREDENTIALS);
            headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.twitpicAPIKey)};
            params = ImageUpload.appendHttpParameters(params, additionalParams);
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWITPIC_UPLOAD_URL, params, headers);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("Twitpic image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            try {
                JSONObject json = new JSONObject(response);
                if (!json.isNull("url")) {
                    return json.getString("url");
                }
            }
            catch (JSONException e) {
                throw new TwitterException("Invalid Twitpic response: " + response, e);
            }
            throw new TwitterException("Unknown Twitpic response", httpResponse);
        }

        private String generateVerifyCredentialsAuthorizationHeader() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "OAuth realm=\"http://api.twitter.com/\"," + OAuthAuthorization.encodeParameters(oauthSignatureParams, ",", true);
        }
    }

    private static class YFrogBasicAuthUploader
    extends ImageUpload {
        private BasicAuthorization auth;
        private static final String YFROG_UPLOAD_URL = "https://yfrog.com/api/upload";

        public YFrogBasicAuthUploader(BasicAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            try {
                message = URLEncoder.encode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            try {
                message = URLEncoder.encode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword())};
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(YFROG_UPLOAD_URL, params = ImageUpload.appendHttpParameters(params, additionalParams));
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("YFrog image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("YFrog image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown YFrog response", httpResponse);
        }
    }

    private static class YFrogOAuthUploader
    extends ImageUpload {
        private String user;
        private OAuthAuthorization auth;
        private static final String YFROG_UPLOAD_URL = "https://yfrog.com/api/upload";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.xml";

        public YFrogOAuthUploader(String user, OAuthAuthorization auth) {
            this.user = user;
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image)});
        }

        public String upload(File image, String message) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", image), new HttpParameter("message", message)});
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody)});
        }

        public String upload(String imageFileName, InputStream imageBody, String message) throws TwitterException {
            try {
                message = URLEncoder.encode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return this.upload(new HttpParameter[]{new HttpParameter("media", imageFileName, imageBody), new HttpParameter("message", message)});
        }

        private String upload(HttpParameter[] additionalParams) throws TwitterException {
            String signedVerifyCredentialsURL = this.generateSignedVerifyCredentialsURL();
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("auth", "oauth"), new HttpParameter("username", this.user), new HttpParameter("verify_url", signedVerifyCredentialsURL)};
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(YFROG_UPLOAD_URL, params = ImageUpload.appendHttpParameters(params, additionalParams));
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("YFrog image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("YFrog image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown YFrog response", httpResponse);
        }

        private String generateSignedVerifyCredentialsURL() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "https://api.twitter.com/1/account/verify_credentials.xml?" + OAuthAuthorization.encodeParameters(oauthSignatureParams);
        }
    }
}

