/*
**  Elaborado por Thomas Sanchez Lengeling
**  Utilizando liberias de mesh para triangulacion de voronoi y delaunay y toxilibs
**
**  Presiona e para expander y contraer y w para monstrar triangulacion
*/

Voronoi           voronoi;
Delaunay          delaunay;
Particles         puntos;
Mesh              mesh;
VerletPhysics2D   physics;

int   numPoints   = 1000;
float noiseValY   = 0.0;
float noiseValX   = 0.1;
int   pSize       = 18;  //tam Particlas Default

float[][]   pointsVD;
float[][]   edgesD;
MPolygon    regionsV[];

boolean showVoronoi;
boolean updateMesh;

//PHYSICS
boolean unLock;
boolean startTrayectory;
int trayectoryType =1;

Vec2D mousePosicion;
AttractionBehavior atraccionMouse;
AttractionBehavior releaseMouse;

int i =0;

void setup() {
  size(1024, 768);
  smooth();

  physics = new VerletPhysics2D();
  physics.setDrag(0.05f);
  physics.setWorldBounds( new Rect(-505, -390, width, height));
  physics.addBehavior(new GravityBehavior(new Vec2D(0.003, 0.03) ) );

  pointsVD = new float[numPoints][2];
  puntos = new Particles(numPoints);
  mesh   = new Mesh();

  ellipseMode(CENTER);
}


void draw() {
  fill(240, 15);
  rect(0, 0, width, height);
  pushMatrix();
  translate(width/2, height/2);

  physics.update();

  if (updateMesh) {
    mesh.draw(this);
    mesh.update();
  }

  startTrayec();
  fill( 0, 50,  150, 40);
  noStroke();
  puntos.draw();
  popMatrix();
}

void keyPressed() {
  switch(key) {
  case 'e':
    startTrayectory = !startTrayectory;
    break;
  case 'q':
    physics.removeBehavior(releaseMouse);
    break;
  case 'w':
    unLock = !unLock;
    mesh.fillPoints();
    updateMesh = !updateMesh;
    showVoronoi = !showVoronoi;
    break;
  }
}

void keyPressed(){
  save("imagen"+i+".jpg"); 
}

